//================================================================================
// DefaultSkin.
//================================================================================
class DanesSkinManager expands Mutator config(DanesSkinManager);

var config string ClanTag;

// Male Clan vars:
var config string MaleClanSkin, MaleClanFace;
var config int MaleClanModel;
// Male Guest vars:
var config string MaleGuestSkin, MaleGuestFace;
var config int MaleGuestModel;

// Female Clan vars:
var config string FemaleClanSkin, FemaleClanFace;
var config int FemaleClanModel;

// Female Guest vars:
var config string FemaleGuestSkin, FemaleGuestFace;
var config int FemaleGuestModel;

var config string TempName[64];		// players nickname
var config int TempModel[64];	// model players is forced to use
//var config string OldModel[64];		// players model before new model was forced on

var bool bResetVars;

function PreBeginPlay()
{
	local int a;
	
	if ( !bResetVars )
		{
		for ( a=0; a<64; a++)
			{
			TempName[a] = "";
			TempModel[a] = 0;
			}
		bResetVars = True;
		log("#------------------------------------------------------------------");
		log("# DanesSkinManager : list of players to modify has been wiped clean");
		log("#------------------------------------------------------------------");
		}
}

function ModifyPlayer(Pawn Other)
{
	local int i;
	local int PlayerTeam;

	for ( i=0; i<64; i++ )
		{
		if (( Other.PlayerReplicationInfo.PlayerName == TempName[i]) || ( TempName[i] == "" ))	// find out what slot to put player into
			{
			if ( Other.PlayerReplicationInfo.PlayerName != TempName[i] ) // check if player has already been proccessed
				{
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;	// add player to the list
				PlayerTeam = Other.PlayerReplicationInfo.Team;
				log("#------------------------------------------------------------------");
				log("# DanesSkinManager : "@TempName[i]$" added to the list");
				SaveConfig(); // only enable for troubleshooting
				if ( Other.PlayerReplicationInfo.bIsFemale )	// check if player is using a female model
					{
					log("# DanesSkinManager : "@TempName[i]$" is using a female model");

					if ((InStr(TempName[i], ClanTag) != -1) && (ClanTag != "")) // Check if Clan tag is in PlayerName
						{
						log("# DanesSkinManager : "@TempName[i]$" is a clanmember, skin and model is set to female clan member");
						Other.SetMultiSkin(Other, ""$FemaleClanSkin, ""$FemaleClanFace, PlayerTeam);
						TempModel[i] = FemaleClanModel;
						}
					else
						{
						log("# DanesSkinManager : "@TempName[i]$" is a guest, skin and model set to female guest");
						Other.SetMultiSkin(Other, ""$FemaleGuestSkin, ""$FemaleGuestFace, PlayerTeam);
						TempModel[i] = FemaleGuestModel;
						// test spawn female guest
						ModifyLogin(PlayerPawn SpawnClass, Portal, Option);
						SpawnClass = class'Botpack.TFemale2';
						}
					}
				else // player is male
					{
					log("# DanesSkinManager : "@TempName[i]$" is using a male model");

					if ((InStr(TempName[i], ClanTag) != -1) && (ClanTag != "")) // Check if Clan tag is in PlayerName
						{
						log("# DanesSkinManager : "@TempName[i]$" is a clanmember, skin and model is set to male clan member");
						Other.SetMultiSkin(Other, ""$MaleClanSkin, ""$MaleClanFace, PlayerTeam);
						TempModel[i] = MaleClanModel;
						}
					else
						{
						log("# DanesSkinManager : "@TempName[i]$" is a guest, skin and model set to male guest");
						Other.SetMultiSkin(Other, ""$MaleGuestSkin, ""$MaleGuestFace, PlayerTeam);
						TempModel[i] = MaleGuestModel;
						}
					}
				}
			i=6000;	// kill loop
			}
		}
}
/*		
function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	
	local int ii;
	local Pawn P;
	// Models:
	// 1=Boss
	// 2=Male Soldier
	// 3=Male Commando
	// 4=Female Soldier
	// 5=Female Commando
	
	for ( ii=0; ii<64; ii++ )
		{
		if ( P.PlayerReplicationInfo.PlayerName == TempName[ii] )
			{
			if ( TempModel[ii] == 1 )
				{
				SpawnClass = class'Botpack.TBoss';
				}
			else if ( TempModel[ii] == 3 )
				{
				SpawnClass = class'Botpack.TMale1';
				}
			else if ( TempModel[ii] == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				}
			else if ( TempModel[ii] == 5 )
				{
				SpawnClass = class'Botpack.TFemale1';
				}
			else if ( TempModel[ii] == 4 )
				{
				SpawnClass = class'Botpack.TFemale2';
				}
			else
				{
				log("# DanesSkinManager : Failed to set model for player: "@P.PlayerReplicationInfo.PlayerName$", player is using unknown model");
				}
			}
		}
	
}

*/



defaultproperties
{

}

/*
function ModifyPlayer(Pawn Other)
{
	
	local int PlayerTeam, i;
	local string PName; // Playername

	PName = Other.PlayerReplicationInfo.PlayerName;
	PlayerTeam = Other.PlayerReplicationInfo.Team;

	for ( i=0; i<128; i++ )
		{
		// Check if Clan tag is in PlayerName
		if((InStr(PName, ClanTag) != -1) && (ClanTag != ""))
			{
			// check if player is male or female
			// and assign temp ID and Model to model spawner
			if ( Other.PlayerReplicationInfo.bIsFemale )
				{
				// set female clan skins
				Other.SetMultiSkin(Other, ""$FemaleClanSkin, ""$FemaleClanFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = FemaleClanModel;
				}
			else
				{
				// set male clan skins
				Other.SetMultiSkin(Other, ""$MaleClanSkin, ""$MaleClanFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = MaleClanModel;
				}
			}
		// Player was not clan member, then check if player is human
		else if ( !Other.PlayerReplicationInfo.bIsABot )
			{
			// check if player is male or female
			// and assign temp ID and Model to model spawner
			if ( Other.PlayerReplicationInfo.bIsFemale )
				{
				// set female guest skins
				Other.SetMultiSkin(Other, ""$FemaleGuestSkin, ""$FemaleGuestFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = FemaleGuestModel;
				}
			else
				{
				// set male guest skins
				Other.SetMultiSkin(Other, ""$MaleGuestSkin, ""$MaleGuestFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = MaleGuestModel;
				}
			}
		// Player was not clan member or human, so player is a bot
		else
			{
			// check if bot is male or female
			// and assign temp ID and Model to model spawner
			if ( Other.PlayerReplicationInfo.bIsFemale )
				{
				// set female bot skins
				Other.SetMultiSkin(Other, ""$FemaleBotSkin, ""$FemaleBotFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = FemaleBotModel;
				}
			else
				{
				// set male bot skins
				Other.SetMultiSkin(Other, ""$MaleGuestSkin, ""$MaleGuestFace, PlayerTeam);
				TempName[i] = Other.PlayerReplicationInfo.PlayerName;
				TempModel[i] = MaleBotModel;
				}
			}
		}
		SaveConfig();
				
}
*/



/*

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	Local Pawn P;
	local PlayerReplicationInfo PRI;
	local int ii;
	// Models:
	// 1=Boss
	// 2=Male Soldier
	// 3=Male Commando
	// 4=Female Spoldier
	// 5=Male Commando
	//PRI = Pawn(Owner);

	for ( ii=0; ii<128; ii++ )
		{
		if ( P.PlayerReplicationInfo.PlayerName == TempName[ii] )
			{
			if ( TempModel[ii] == "Boss" )
				{
				SpawnClass = class'Botpack.TBoss';
				}
			else if ( TempModel[ii] == "MaleCommando" )
				{
				SpawnClass = class'Botpack.TMale1';
				}
			else if ( TempModel[ii] == "MaleSoldier" )
				{
				SpawnClass = class'Botpack.TMale2';
				}
			else if ( TempModel[ii] == "FemaleCommando" )
				{
				SpawnClass = class'Botpack.TFemale1';
				}
			else if ( TempModel[ii] == "FemaleSoldier" )
				{
				SpawnClass = class'Botpack.TFemale2';
				}
			else
				{
				log("# DanesSkinManager : Failed to set model for player: "@P.PlayerReplicationInfo.PlayerName$", player is using unknown model");
				}
			}
		}
	
}

*/
